/*
 * File:    mcf548x_usb.h
 * Purpose: Register and bit definitions
 */

#ifndef __MCF548X_USB_H__
#define __MCF548X_USB_H__

/*********************************************************************
*
* Universal Serial Bus (USB)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_USB_USBAISR                (*(vuint8 *)(&__MBAR[0x00B000]))
#define MCF_USB_USBAIMR                (*(vuint8 *)(&__MBAR[0x00B001]))
#define MCF_USB_EPINFO                 (*(vuint8 *)(&__MBAR[0x00B003]))
#define MCF_USB_CFGR                   (*(vuint8 *)(&__MBAR[0x00B004]))
#define MCF_USB_CFGAR                  (*(vuint8 *)(&__MBAR[0x00B005]))
#define MCF_USB_SPEEDR                 (*(vuint8 *)(&__MBAR[0x00B006]))
#define MCF_USB_FRMNUMR                (*(vuint16*)(&__MBAR[0x00B00E]))
#define MCF_USB_EPTNR                  (*(vuint16*)(&__MBAR[0x00B010]))
#define MCF_USB_IFUR                   (*(vuint16*)(&__MBAR[0x00B014]))
#define MCF_USB_IFR0                   (*(vuint16*)(&__MBAR[0x00B040]))
#define MCF_USB_IFR1                   (*(vuint16*)(&__MBAR[0x00B042]))
#define MCF_USB_IFR2                   (*(vuint16*)(&__MBAR[0x00B044]))
#define MCF_USB_IFR3                   (*(vuint16*)(&__MBAR[0x00B046]))
#define MCF_USB_IFR4                   (*(vuint16*)(&__MBAR[0x00B048]))
#define MCF_USB_IFR5                   (*(vuint16*)(&__MBAR[0x00B04A]))
#define MCF_USB_IFR6                   (*(vuint16*)(&__MBAR[0x00B04C]))
#define MCF_USB_IFR7                   (*(vuint16*)(&__MBAR[0x00B04E]))
#define MCF_USB_IFR8                   (*(vuint16*)(&__MBAR[0x00B050]))
#define MCF_USB_IFR9                   (*(vuint16*)(&__MBAR[0x00B052]))
#define MCF_USB_IFR10                  (*(vuint16*)(&__MBAR[0x00B054]))
#define MCF_USB_IFR11                  (*(vuint16*)(&__MBAR[0x00B056]))
#define MCF_USB_IFR12                  (*(vuint16*)(&__MBAR[0x00B058]))
#define MCF_USB_IFR13                  (*(vuint16*)(&__MBAR[0x00B05A]))
#define MCF_USB_IFR14                  (*(vuint16*)(&__MBAR[0x00B05C]))
#define MCF_USB_IFR15                  (*(vuint16*)(&__MBAR[0x00B05E]))
#define MCF_USB_IFR16                  (*(vuint16*)(&__MBAR[0x00B060]))
#define MCF_USB_IFR17                  (*(vuint16*)(&__MBAR[0x00B062]))
#define MCF_USB_IFR18                  (*(vuint16*)(&__MBAR[0x00B064]))
#define MCF_USB_IFR19                  (*(vuint16*)(&__MBAR[0x00B066]))
#define MCF_USB_IFR20                  (*(vuint16*)(&__MBAR[0x00B068]))
#define MCF_USB_IFR21                  (*(vuint16*)(&__MBAR[0x00B06A]))
#define MCF_USB_IFR22                  (*(vuint16*)(&__MBAR[0x00B06C]))
#define MCF_USB_IFR23                  (*(vuint16*)(&__MBAR[0x00B06E]))
#define MCF_USB_IFR24                  (*(vuint16*)(&__MBAR[0x00B070]))
#define MCF_USB_IFR25                  (*(vuint16*)(&__MBAR[0x00B072]))
#define MCF_USB_IFR26                  (*(vuint16*)(&__MBAR[0x00B074]))
#define MCF_USB_IFR27                  (*(vuint16*)(&__MBAR[0x00B076]))
#define MCF_USB_IFR28                  (*(vuint16*)(&__MBAR[0x00B078]))
#define MCF_USB_IFR29                  (*(vuint16*)(&__MBAR[0x00B07A]))
#define MCF_USB_IFR30                  (*(vuint16*)(&__MBAR[0x00B07C]))
#define MCF_USB_IFR31                  (*(vuint16*)(&__MBAR[0x00B07E]))
#define MCF_USB_IFR(x)                 (*(vuint16*)(&__MBAR[0x00B040+((x)*0x002)]))
#define MCF_USB_PPCNT                  (*(vuint16*)(&__MBAR[0x00B080]))
#define MCF_USB_DPCNT                  (*(vuint16*)(&__MBAR[0x00B082]))
#define MCF_USB_CRCECNT                (*(vuint16*)(&__MBAR[0x00B084]))
#define MCF_USB_BSECNT                 (*(vuint16*)(&__MBAR[0x00B086]))
#define MCF_USB_PIDECNT                (*(vuint16*)(&__MBAR[0x00B088]))
#define MCF_USB_FRMECNT                (*(vuint16*)(&__MBAR[0x00B08A]))
#define MCF_USB_TXPCNT                 (*(vuint16*)(&__MBAR[0x00B08C]))
#define MCF_USB_CNTOVR                 (*(vuint8 *)(&__MBAR[0x00B08E]))
#define MCF_USB_EP0ACR                 (*(vuint8 *)(&__MBAR[0x00B101]))
#define MCF_USB_EP0MPSR                (*(vuint16*)(&__MBAR[0x00B102]))
#define MCF_USB_EP0IFR                 (*(vuint8 *)(&__MBAR[0x00B104]))
#define MCF_USB_EP0SR                  (*(vuint8 *)(&__MBAR[0x00B105]))
#define MCF_USB_BMRTR                  (*(vuint8 *)(&__MBAR[0x00B106]))
#define MCF_USB_BRTR                   (*(vuint8 *)(&__MBAR[0x00B107]))
#define MCF_USB_WVALUER                (*(vuint16*)(&__MBAR[0x00B108]))
#define MCF_USB_WINDEXR                (*(vuint16*)(&__MBAR[0x00B10A]))
#define MCF_USB_WLENGTH                (*(vuint16*)(&__MBAR[0x00B10C]))
#define MCF_USB_EP1OUTACR              (*(vuint8 *)(&__MBAR[0x00B131]))
#define MCF_USB_EP2OUTACR              (*(vuint8 *)(&__MBAR[0x00B161]))
#define MCF_USB_EP3OUTACR              (*(vuint8 *)(&__MBAR[0x00B191]))
#define MCF_USB_EP4OUTACR              (*(vuint8 *)(&__MBAR[0x00B1C1]))
#define MCF_USB_EP5OUTACR              (*(vuint8 *)(&__MBAR[0x00B1F1]))
#define MCF_USB_EP6OUTACR              (*(vuint8 *)(&__MBAR[0x00B221]))
#define MCF_USB_EPOUTACR(x)            (*(vuint8 *)(&__MBAR[0x00B131+((x-1)*0x030)]))
#define MCF_USB_EP1OUTMPSR             (*(vuint16*)(&__MBAR[0x00B132]))
#define MCF_USB_EP2OUTMPSR             (*(vuint16*)(&__MBAR[0x00B162]))
#define MCF_USB_EP3OUTMPSR             (*(vuint16*)(&__MBAR[0x00B192]))
#define MCF_USB_EP4OUTMPSR             (*(vuint16*)(&__MBAR[0x00B1C2]))
#define MCF_USB_EP5OUTMPSR             (*(vuint16*)(&__MBAR[0x00B1F2]))
#define MCF_USB_EP6OUTMPSR             (*(vuint16*)(&__MBAR[0x00B222]))
#define MCF_USB_EPOUTMPSR(x)           (*(vuint16*)(&__MBAR[0x00B132+((x-1)*0x030)]))
#define MCF_USB_EP1OUTIFR              (*(vuint8 *)(&__MBAR[0x00B134]))
#define MCF_USB_EP2OUTIFR              (*(vuint8 *)(&__MBAR[0x00B164]))
#define MCF_USB_EP3OUTIFR              (*(vuint8 *)(&__MBAR[0x00B194]))
#define MCF_USB_EP4OUTIFR              (*(vuint8 *)(&__MBAR[0x00B1C4]))
#define MCF_USB_EP5OUTIFR              (*(vuint8 *)(&__MBAR[0x00B1F4]))
#define MCF_USB_EP6OUTIFR              (*(vuint8 *)(&__MBAR[0x00B224]))
#define MCF_USB_EPOUTIFR(x)            (*(vuint8 *)(&__MBAR[0x00B134+((x-1)*0x030)]))
#define MCF_USB_EP1OUTSR               (*(vuint8 *)(&__MBAR[0x00B135]))
#define MCF_USB_EP2OUTSR               (*(vuint8 *)(&__MBAR[0x00B165]))
#define MCF_USB_EP3OUTSR               (*(vuint8 *)(&__MBAR[0x00B195]))
#define MCF_USB_EP4OUTSR               (*(vuint8 *)(&__MBAR[0x00B1C5]))
#define MCF_USB_EP5OUTSR               (*(vuint8 *)(&__MBAR[0x00B1F5]))
#define MCF_USB_EP6OUTSR               (*(vuint8 *)(&__MBAR[0x00B225]))
#define MCF_USB_EPOUTSR(x)             (*(vuint8 *)(&__MBAR[0x00B135+((x-1)*0x030)]))
#define MCF_USB_EP1OUTSFR              (*(vuint16*)(&__MBAR[0x00B13E]))
#define MCF_USB_EP2OUTSFR              (*(vuint16*)(&__MBAR[0x00B16E]))
#define MCF_USB_EP3OUTSFR              (*(vuint16*)(&__MBAR[0x00B19E]))
#define MCF_USB_EP4OUTSFR              (*(vuint16*)(&__MBAR[0x00B1CE]))
#define MCF_USB_EP5OUTSFR              (*(vuint16*)(&__MBAR[0x00B1FE]))
#define MCF_USB_EP6OUTSFR              (*(vuint16*)(&__MBAR[0x00B22E]))
#define MCF_USB_EPOUTSFR(x)            (*(vuint16*)(&__MBAR[0x00B13E+((x-1)*0x030)]))
#define MCF_USB_EP1INACR               (*(vuint8 *)(&__MBAR[0x00B149]))
#define MCF_USB_EP2INACR               (*(vuint8 *)(&__MBAR[0x00B179]))
#define MCF_USB_EP3INACR               (*(vuint8 *)(&__MBAR[0x00B1A9]))
#define MCF_USB_EP4INACR               (*(vuint8 *)(&__MBAR[0x00B1D9]))
#define MCF_USB_EP5INACR               (*(vuint8 *)(&__MBAR[0x00B209]))
#define MCF_USB_EP6INACR               (*(vuint8 *)(&__MBAR[0x00B239]))
#define MCF_USB_EPINACR(x)             (*(vuint8 *)(&__MBAR[0x00B149+((x-1)*0x030)]))
#define MCF_USB_EP1INMPSR              (*(vuint16*)(&__MBAR[0x00B14A]))
#define MCF_USB_EP2INMPSR              (*(vuint16*)(&__MBAR[0x00B17A]))
#define MCF_USB_EP3INMPSR              (*(vuint16*)(&__MBAR[0x00B1AA]))
#define MCF_USB_EP4INMPSR              (*(vuint16*)(&__MBAR[0x00B1DA]))
#define MCF_USB_EP5INMPSR              (*(vuint16*)(&__MBAR[0x00B20A]))
#define MCF_USB_EP6INMPSR              (*(vuint16*)(&__MBAR[0x00B23A]))
#define MCF_USB_EPINMPSR(x)            (*(vuint16*)(&__MBAR[0x00B14A+((x-1)*0x030)]))
#define MCF_USB_EP1INIFR               (*(vuint8 *)(&__MBAR[0x00B14C]))
#define MCF_USB_EP2INIFR               (*(vuint8 *)(&__MBAR[0x00B17C]))
#define MCF_USB_EP3INIFR               (*(vuint8 *)(&__MBAR[0x00B1AC]))
#define MCF_USB_EP4INIFR               (*(vuint8 *)(&__MBAR[0x00B1DC]))
#define MCF_USB_EP5INIFR               (*(vuint8 *)(&__MBAR[0x00B20C]))
#define MCF_USB_EP6INIFR               (*(vuint8 *)(&__MBAR[0x00B23C]))
#define MCF_USB_EPINIFR(x)             (*(vuint8 *)(&__MBAR[0x00B14C+((x-1)*0x030)]))
#define MCF_USB_EP1INSR                (*(vuint8 *)(&__MBAR[0x00B14D]))
#define MCF_USB_EP2INSR                (*(vuint8 *)(&__MBAR[0x00B17D]))
#define MCF_USB_EP3INSR                (*(vuint8 *)(&__MBAR[0x00B1AD]))
#define MCF_USB_EP4INSR                (*(vuint8 *)(&__MBAR[0x00B1DD]))
#define MCF_USB_EP5INSR                (*(vuint8 *)(&__MBAR[0x00B20D]))
#define MCF_USB_EP6INSR                (*(vuint8 *)(&__MBAR[0x00B23D]))
#define MCF_USB_EPINSR(x)              (*(vuint8 *)(&__MBAR[0x00B14D+((x-1)*0x030)]))
#define MCF_USB_EP1INSFR               (*(vuint16*)(&__MBAR[0x00B15A]))
#define MCF_USB_EP2INSFR               (*(vuint16*)(&__MBAR[0x00B18A]))
#define MCF_USB_EP3INSFR               (*(vuint16*)(&__MBAR[0x00B1BA]))
#define MCF_USB_EP4INSFR               (*(vuint16*)(&__MBAR[0x00B1EA]))
#define MCF_USB_EP5INSFR               (*(vuint16*)(&__MBAR[0x00B21A]))
#define MCF_USB_EP6INSFR               (*(vuint16*)(&__MBAR[0x00B24A]))
#define MCF_USB_EPINSFR(x)             (*(vuint16*)(&__MBAR[0x00B15A+((x-1)*0x030)]))
#define MCF_USB_USBSR                  (*(vuint32*)(&__MBAR[0x00B400]))
#define MCF_USB_USBCR                  (*(vuint32*)(&__MBAR[0x00B404]))
#define MCF_USB_DRAMCR                 (*(vuint32*)(&__MBAR[0x00B408]))
#define MCF_USB_DRAMDR                 (*(vuint32*)(&__MBAR[0x00B40C]))
#define MCF_USB_USBISR                 (*(vuint32*)(&__MBAR[0x00B410]))
#define MCF_USB_USBIMR                 (*(vuint32*)(&__MBAR[0x00B414]))
#define MCF_USB_EP0STAT                (*(vuint32*)(&__MBAR[0x00B440]))
#define MCF_USB_EP1STAT                (*(vuint32*)(&__MBAR[0x00B470]))
#define MCF_USB_EP2STAT                (*(vuint32*)(&__MBAR[0x00B4A0]))
#define MCF_USB_EP3STAT                (*(vuint32*)(&__MBAR[0x00B4D0]))
#define MCF_USB_EP4STAT                (*(vuint32*)(&__MBAR[0x00B500]))
#define MCF_USB_EP5STAT                (*(vuint32*)(&__MBAR[0x00B530]))
#define MCF_USB_EP6STAT                (*(vuint32*)(&__MBAR[0x00B560]))
#define MCF_USB_EPSTAT(x)              (*(vuint32*)(&__MBAR[0x00B440+((x)*0x030)]))
#define MCF_USB_EP0ISR                 (*(vuint32*)(&__MBAR[0x00B444]))
#define MCF_USB_EP1ISR                 (*(vuint32*)(&__MBAR[0x00B474]))
#define MCF_USB_EP2ISR                 (*(vuint32*)(&__MBAR[0x00B4A4]))
#define MCF_USB_EP3ISR                 (*(vuint32*)(&__MBAR[0x00B4D4]))
#define MCF_USB_EP4ISR                 (*(vuint32*)(&__MBAR[0x00B504]))
#define MCF_USB_EP5ISR                 (*(vuint32*)(&__MBAR[0x00B534]))
#define MCF_USB_EP6ISR                 (*(vuint32*)(&__MBAR[0x00B564]))
#define MCF_USB_EPISR(x)               (*(vuint32*)(&__MBAR[0x00B444+((x)*0x030)]))
#define MCF_USB_EP0IMR                 (*(vuint32*)(&__MBAR[0x00B448]))
#define MCF_USB_EP1IMR                 (*(vuint32*)(&__MBAR[0x00B478]))
#define MCF_USB_EP2IMR                 (*(vuint32*)(&__MBAR[0x00B4A8]))
#define MCF_USB_EP3IMR                 (*(vuint32*)(&__MBAR[0x00B4D8]))
#define MCF_USB_EP4IMR                 (*(vuint32*)(&__MBAR[0x00B508]))
#define MCF_USB_EP5IMR                 (*(vuint32*)(&__MBAR[0x00B538]))
#define MCF_USB_EP6IMR                 (*(vuint32*)(&__MBAR[0x00B568]))
#define MCF_USB_EPIMR(x)               (*(vuint32*)(&__MBAR[0x00B448+((x)*0x030)]))
#define MCF_USB_EP0FRCFGR              (*(vuint32*)(&__MBAR[0x00B44C]))
#define MCF_USB_EP1FRCFGR              (*(vuint32*)(&__MBAR[0x00B47C]))
#define MCF_USB_EP2FRCFGR              (*(vuint32*)(&__MBAR[0x00B4AC]))
#define MCF_USB_EP3FRCFGR              (*(vuint32*)(&__MBAR[0x00B4DC]))
#define MCF_USB_EP4FRCFGR              (*(vuint32*)(&__MBAR[0x00B50C]))
#define MCF_USB_EP5FRCFGR              (*(vuint32*)(&__MBAR[0x00B53C]))
#define MCF_USB_EP6FRCFGR              (*(vuint32*)(&__MBAR[0x00B56C]))
#define MCF_USB_EPFRCFGR(x)            (*(vuint32*)(&__MBAR[0x00B44C+((x)*0x030)]))
#define MCF_USB_EP0FDR                 (*(vuint32*)(&__MBAR[0x00B450]))
#define MCF_USB_EP1FDR                 (*(vuint32*)(&__MBAR[0x00B480]))
#define MCF_USB_EP2FDR                 (*(vuint32*)(&__MBAR[0x00B4B0]))
#define MCF_USB_EP3FDR                 (*(vuint32*)(&__MBAR[0x00B4E0]))
#define MCF_USB_EP4FDR                 (*(vuint32*)(&__MBAR[0x00B510]))
#define MCF_USB_EP5FDR                 (*(vuint32*)(&__MBAR[0x00B540]))
#define MCF_USB_EP6FDR                 (*(vuint32*)(&__MBAR[0x00B570]))
#define MCF_USB_EPFDR(x)               (*(vuint32*)(&__MBAR[0x00B450+((x)*0x030)]))
#define MCF_USB_EP0FDR_32              (*(vuint32*)(&__MBAR[0x00B450]))
#define MCF_USB_EP1FDR_32              (*(vuint32*)(&__MBAR[0x00B480]))
#define MCF_USB_EP2FDR_32              (*(vuint32*)(&__MBAR[0x00B4B0]))
#define MCF_USB_EP3FDR_32              (*(vuint32*)(&__MBAR[0x00B4E0]))
#define MCF_USB_EP4FDR_32              (*(vuint32*)(&__MBAR[0x00B510]))
#define MCF_USB_EP5FDR_32              (*(vuint32*)(&__MBAR[0x00B540]))
#define MCF_USB_EP6FDR_32              (*(vuint32*)(&__MBAR[0x00B570]))
#define MCF_USB_EPFDR_32(x)            (*(vuint32*)(&__MBAR[0x00B450+((x)*0x030)]))
#define MCF_USB_EP0FDR_16              (*(vuint16*)(&__MBAR[0x00B450]))
#define MCF_USB_EP1FDR_16              (*(vuint16*)(&__MBAR[0x00B480]))
#define MCF_USB_EP2FDR_16              (*(vuint16*)(&__MBAR[0x00B4B0]))
#define MCF_USB_EP3FDR_16              (*(vuint16*)(&__MBAR[0x00B4E0]))
#define MCF_USB_EP4FDR_16              (*(vuint16*)(&__MBAR[0x00B510]))
#define MCF_USB_EP5FDR_16              (*(vuint16*)(&__MBAR[0x00B540]))
#define MCF_USB_EP6FDR_16              (*(vuint16*)(&__MBAR[0x00B570]))
#define MCF_USB_EPFDR_16(x)            (*(vuint16*)(&__MBAR[0x00B450+((x)*0x030)]))
#define MCF_USB_EP0FDR_8               (*(vuint8 *)(&__MBAR[0x00B450]))
#define MCF_USB_EP1FDR_8               (*(vuint8 *)(&__MBAR[0x00B480]))
#define MCF_USB_EP2FDR_8               (*(vuint8 *)(&__MBAR[0x00B4B0]))
#define MCF_USB_EP3FDR_8               (*(vuint8 *)(&__MBAR[0x00B4E0]))
#define MCF_USB_EP4FDR_8               (*(vuint8 *)(&__MBAR[0x00B510]))
#define MCF_USB_EP5FDR_8               (*(vuint8 *)(&__MBAR[0x00B540]))
#define MCF_USB_EP6FDR_8               (*(vuint8 *)(&__MBAR[0x00B570]))
#define MCF_USB_EPFDR_8(x)             (*(vuint8 *)(&__MBAR[0x00B450+((x)*0x030)]))
#define MCF_USB_EP0FSR                 (*(vuint32*)(&__MBAR[0x00B454]))
#define MCF_USB_EP1FSR                 (*(vuint32*)(&__MBAR[0x00B484]))
#define MCF_USB_EP2FSR                 (*(vuint32*)(&__MBAR[0x00B4B4]))
#define MCF_USB_EP3FSR                 (*(vuint32*)(&__MBAR[0x00B4E4]))
#define MCF_USB_EP4FSR                 (*(vuint32*)(&__MBAR[0x00B514]))
#define MCF_USB_EP5FSR                 (*(vuint32*)(&__MBAR[0x00B544]))
#define MCF_USB_EP6FSR                 (*(vuint32*)(&__MBAR[0x00B574]))
#define MCF_USB_EPFSR(x)               (*(vuint32*)(&__MBAR[0x00B454+((x)*0x030)]))
#define MCF_USB_EP0FCR                 (*(vuint32*)(&__MBAR[0x00B458]))
#define MCF_USB_EP1FCR                 (*(vuint32*)(&__MBAR[0x00B488]))
#define MCF_USB_EP2FCR                 (*(vuint32*)(&__MBAR[0x00B4B8]))
#define MCF_USB_EP3FCR                 (*(vuint32*)(&__MBAR[0x00B4E8]))
#define MCF_USB_EP4FCR                 (*(vuint32*)(&__MBAR[0x00B518]))
#define MCF_USB_EP5FCR                 (*(vuint32*)(&__MBAR[0x00B548]))
#define MCF_USB_EP6FCR                 (*(vuint32*)(&__MBAR[0x00B578]))
#define MCF_USB_EPFCR(x)               (*(vuint32*)(&__MBAR[0x00B458+((x)*0x030)]))
#define MCF_USB_EP0FAR                 (*(vuint32*)(&__MBAR[0x00B45C]))
#define MCF_USB_EP1FAR                 (*(vuint32*)(&__MBAR[0x00B48C]))
#define MCF_USB_EP2FAR                 (*(vuint32*)(&__MBAR[0x00B4BC]))
#define MCF_USB_EP3FAR                 (*(vuint32*)(&__MBAR[0x00B4EC]))
#define MCF_USB_EP4FAR                 (*(vuint32*)(&__MBAR[0x00B51C]))
#define MCF_USB_EP5FAR                 (*(vuint32*)(&__MBAR[0x00B54C]))
#define MCF_USB_EP6FAR                 (*(vuint32*)(&__MBAR[0x00B57C]))
#define MCF_USB_EPFAR(x)               (*(vuint32*)(&__MBAR[0x00B45C+((x)*0x030)]))
#define MCF_USB_EP0FRP                 (*(vuint32*)(&__MBAR[0x00B460]))
#define MCF_USB_EP1FRP                 (*(vuint32*)(&__MBAR[0x00B490]))
#define MCF_USB_EP2FRP                 (*(vuint32*)(&__MBAR[0x00B4C0]))
#define MCF_USB_EP3FRP                 (*(vuint32*)(&__MBAR[0x00B4F0]))
#define MCF_USB_EP4FRP                 (*(vuint32*)(&__MBAR[0x00B520]))
#define MCF_USB_EP5FRP                 (*(vuint32*)(&__MBAR[0x00B550]))
#define MCF_USB_EP6FRP                 (*(vuint32*)(&__MBAR[0x00B580]))
#define MCF_USB_EPFRP(x)               (*(vuint32*)(&__MBAR[0x00B460+((x)*0x030)]))
#define MCF_USB_EP0FWP                 (*(vuint32*)(&__MBAR[0x00B464]))
#define MCF_USB_EP1FWP                 (*(vuint32*)(&__MBAR[0x00B494]))
#define MCF_USB_EP2FWP                 (*(vuint32*)(&__MBAR[0x00B4C4]))
#define MCF_USB_EP3FWP                 (*(vuint32*)(&__MBAR[0x00B4F4]))
#define MCF_USB_EP4FWP                 (*(vuint32*)(&__MBAR[0x00B524]))
#define MCF_USB_EP5FWP                 (*(vuint32*)(&__MBAR[0x00B554]))
#define MCF_USB_EP6FWP                 (*(vuint32*)(&__MBAR[0x00B584]))
#define MCF_USB_EPFWP(x)               (*(vuint32*)(&__MBAR[0x00B464+((x)*0x030)]))
#define MCF_USB_EP0LRFP                (*(vuint32*)(&__MBAR[0x00B468]))
#define MCF_USB_EP1LRFP                (*(vuint32*)(&__MBAR[0x00B498]))
#define MCF_USB_EP2LRFP                (*(vuint32*)(&__MBAR[0x00B4C8]))
#define MCF_USB_EP3LRFP                (*(vuint32*)(&__MBAR[0x00B4F8]))
#define MCF_USB_EP4LRFP                (*(vuint32*)(&__MBAR[0x00B528]))
#define MCF_USB_EP5LRFP                (*(vuint32*)(&__MBAR[0x00B558]))
#define MCF_USB_EP6LRFP                (*(vuint32*)(&__MBAR[0x00B588]))
#define MCF_USB_EPLRFP(x)              (*(vuint32*)(&__MBAR[0x00B468+((x)*0x030)]))
#define MCF_USB_EP0LWFP                (*(vuint32*)(&__MBAR[0x00B46C]))
#define MCF_USB_EP1LWFP                (*(vuint32*)(&__MBAR[0x00B49C]))
#define MCF_USB_EP2LWFP                (*(vuint32*)(&__MBAR[0x00B4CC]))
#define MCF_USB_EP3LWFP                (*(vuint32*)(&__MBAR[0x00B4FC]))
#define MCF_USB_EP4LWFP                (*(vuint32*)(&__MBAR[0x00B52C]))
#define MCF_USB_EP5LWFP                (*(vuint32*)(&__MBAR[0x00B55C]))
#define MCF_USB_EP6LWFP                (*(vuint32*)(&__MBAR[0x00B58C]))
#define MCF_USB_EPLWFP(x)              (*(vuint32*)(&__MBAR[0x00B46C+((x)*0x030)]))

/* Bit definitions and macros for MCF_USB_USBAISR */
#define MCF_USB_USBAISR_SETUP          (0x01)
#define MCF_USB_USBAISR_IN             (0x02)
#define MCF_USB_USBAISR_OUT            (0x04)
#define MCF_USB_USBAISR_EPHALT         (0x08)
#define MCF_USB_USBAISR_TRANSERR       (0x10)
#define MCF_USB_USBAISR_ACK            (0x20)
#define MCF_USB_USBAISR_CTROVFL        (0x40)
#define MCF_USB_USBAISR_EPSTALL        (0x80)

/* Bit definitions and macros for MCF_USB_USBAIMR */
#define MCF_USB_USBAIMR_SETUPEN        (0x01)
#define MCF_USB_USBAIMR_INEN           (0x02)
#define MCF_USB_USBAIMR_OUTEN          (0x04)
#define MCF_USB_USBAIMR_EPHALTEN       (0x08)
#define MCF_USB_USBAIMR_TRANSERREN     (0x10)
#define MCF_USB_USBAIMR_ACKEN          (0x20)
#define MCF_USB_USBAIMR_CTROVFLEN      (0x40)
#define MCF_USB_USBAIMR_EPSTALLEN      (0x80)

/* Bit definitions and macros for MCF_USB_EPINFO */
#define MCF_USB_EPINFO_EPDIR           (0x01)
#define MCF_USB_EPINFO_EPNUM(x)        (((x)&0x07)<<1)

/* Bit definitions and macros for MCF_USB_CFGAR */
#define MCF_USB_CFGAR_RMTWKEUP         (0x40)

/* Bit definitions and macros for MCF_USB_SPEEDR */
#define MCF_USB_SPEEDR_HS              (0x01)
#define MCF_USB_SPEEDR_FS              (0x02)

/* Bit definitions and macros for MCF_USB_FRMNUMR */
#define MCF_USB_FRMNUMR_FRMNUM(x)      (((x)&0x0FFF)<<0)

/* Bit definitions and macros for MCF_USB_EPTNR */
#define MCF_USB_EPTNR_EP1T(x)          (((x)&0x0003)<<0)
#define MCF_USB_EPTNR_EP2T(x)          (((x)&0x0003)<<2)
#define MCF_USB_EPTNR_EP3T(x)          (((x)&0x0003)<<4)
#define MCF_USB_EPTNR_EP4T(x)          (((x)&0x0003)<<6)
#define MCF_USB_EPTNR_EP5T(x)          (((x)&0x0003)<<8)
#define MCF_USB_EPTNR_EP6T(x)          (((x)&0x0003)<<10)
#define MCF_USB_EPTNR_EPnT1            (0)
#define MCF_USB_EPTNR_EPnT2            (1)
#define MCF_USB_EPTNR_EPnT3            (2)

/* Bit definitions and macros for MCF_USB_IFUR */
#define MCF_USB_IFUR_ALTSET(x)         (((x)&0x00FF)<<0)
#define MCF_USB_IFUR_IFNUM(x)          (((x)&0x00FF)<<8)

/* Bit definitions and macros for MCF_USB_IFR */
#define MCF_USB_IFR_ALTSET(x)          (((x)&0x00FF)<<0)
#define MCF_USB_IFR_IFNUM(x)           (((x)&0x00FF)<<8)

/* Bit definitions and macros for MCF_USB_CNTOVR */
#define MCF_USB_CNTOVR_PPCNT           (0x01)
#define MCF_USB_CNTOVR_DPCNT           (0x02)
#define MCF_USB_CNTOVR_CRCECNT         (0x04)
#define MCF_USB_CNTOVR_BSECNT          (0x08)
#define MCF_USB_CNTOVR_PIDECNT         (0x10)
#define MCF_USB_CNTOVR_FRMECNT         (0x20)
#define MCF_USB_CNTOVR_TXPCNT          (0x40)

/* Bit definitions and macros for MCF_USB_EP0ACR */
#define MCF_USB_EP0ACR_TTYPE(x)        (((x)&0x03)<<0)
#define MCF_USB_EP0ACR_TTYPE_CTRL      (0)
#define MCF_USB_EP0ACR_TTYPE_ISOC      (1)
#define MCF_USB_EP0ACR_TTYPE_BULK      (2)
#define MCF_USB_EP0ACR_TTYPE_INT       (3)

/* Bit definitions and macros for MCF_USB_EP0MPSR */
#define MCF_USB_EP0MPSR_MAXPKTSZ(x)    (((x)&0x07FF)<<0)
#define MCF_USB_EP0MPSR_ADDTRANS(x)    (((x)&0x0003)<<11)

/* Bit definitions and macros for MCF_USB_EP0SR */
#define MCF_USB_EP0SR_HALT             (0x01)
#define MCF_USB_EP0SR_ACTIVE           (0x02)
#define MCF_USB_EP0SR_PSTALL           (0x04)
#define MCF_USB_EP0SR_CCOMP            (0x08)
#define MCF_USB_EP0SR_TXZERO           (0x20)
#define MCF_USB_EP0SR_INT              (0x80)

/* Bit definitions and macros for MCF_USB_BMRTR */
#define MCF_USB_BMRTR_DIR              (0x80)
#define MCF_USB_BMRTR_TYPE_STANDARD    (0x00)
#define MCF_USB_BMRTR_TYPE_CLASS       (0x20)
#define MCF_USB_BMRTR_TYPE_VENDOR      (0x40)
#define MCF_USB_BMRTR_REC_DEVICE       (0x00)
#define MCF_USB_BMRTR_REC_INTERFACE    (0x01)
#define MCF_USB_BMRTR_REC_ENDPOINT     (0x02)
#define MCF_USB_BMRTR_REC_OTHER        (0x03)

/* Bit definitions and macros for MCF_USB_EPOUTACR */
#define MCF_USB_EPOUTACR_TTYPE(x)      (((x)&0x03)<<0)

/* Bit definitions and macros for MCF_USB_EPOUTMPSR */
#define MCF_USB_EPOUTMPSR_MAXPKTSZ(x)  (((x)&0x07FF)<<0)
#define MCF_USB_EPOUTMPSR_ADDTRANS(x)  (((x)&0x0003)<<11)

/* Bit definitions and macros for MCF_USB_EPOUTSR */
#define MCF_USB_EPOUTSR_HALT           (0x01)
#define MCF_USB_EPOUTSR_ACTIVE         (0x02)
#define MCF_USB_EPOUTSR_PSTALL         (0x04)
#define MCF_USB_EPOUTSR_CCOMP          (0x08)
#define MCF_USB_EPOUTSR_TXZERO         (0x20)
#define MCF_USB_EPOUTSR_INT            (0x80)

/* Bit definitions and macros for MCF_USB_EPOUTSFR */
#define MCF_USB_EPOUTSFR_FRMNUM(x)     (((x)&0x07FF)<<0)

/* Bit definitions and macros for MCF_USB_EPINACR */
#define MCF_USB_EPINACR_TTYPE(x)       (((x)&0x03)<<0)

/* Bit definitions and macros for MCF_USB_EPINMPSR */
#define MCF_USB_EPINMPSR_MAXPKTSZ(x)   (((x)&0x07FF)<<0)
#define MCF_USB_EPINMPSR_ADDTRANS(x)   (((x)&0x0003)<<11)

/* Bit definitions and macros for MCF_USB_EPINSR */
#define MCF_USB_EPINSR_HALT            (0x01)
#define MCF_USB_EPINSR_ACTIVE          (0x02)
#define MCF_USB_EPINSR_PSTALL          (0x04)
#define MCF_USB_EPINSR_CCOMP           (0x08)
#define MCF_USB_EPINSR_TXZERO          (0x20)
#define MCF_USB_EPINSR_INT             (0x80)

/* Bit definitions and macros for MCF_USB_EPINSFR */
#define MCF_USB_EPINSFR_FRMNUM(x)      (((x)&0x07FF)<<0)

/* Bit definitions and macros for MCF_USB_USBSR */
#define MCF_USB_USBSR_SUSP             (0x00000080)
#define MCF_USB_USBSR_ISOERREP         (0x0000000F)

/* Bit definitions and macros for MCF_USB_USBCR */
#define MCF_USB_USBCR_RESUME           (0x00000001)
#define MCF_USB_USBCR_APPLOCK          (0x00000002)
#define MCF_USB_USBCR_RST              (0x00000004)
#define MCF_USB_USBCR_RAMEN            (0x00000008)
#define MCF_USB_USBCR_RAMSPLIT         (0x00000020)

/* Bit definitions and macros for MCF_USB_DRAMCR */
#define MCF_USB_DRAMCR_DADR(x)         (((x)&0x000003FF)<<0)
#define MCF_USB_DRAMCR_DSIZE(x)        (((x)&0x000007FF)<<16)
#define MCF_USB_DRAMCR_BSY             (0x40000000)
#define MCF_USB_DRAMCR_START           (0x80000000)

/* Bit definitions and macros for MCF_USB_DRAMDR */
#define MCF_USB_DRAMDR_DDAT(x)         (((x)&0x000000FF)<<0)

/* Bit definitions and macros for MCF_USB_USBISR */
#define MCF_USB_USBISR_ISOERR          (0x00000001)
#define MCF_USB_USBISR_FTUNLCK         (0x00000002)
#define MCF_USB_USBISR_SUSP            (0x00000004)
#define MCF_USB_USBISR_RES             (0x00000008)
#define MCF_USB_USBISR_UPDSOF          (0x00000010)
#define MCF_USB_USBISR_RSTSTOP         (0x00000020)
#define MCF_USB_USBISR_SOF             (0x00000040)
#define MCF_USB_USBISR_MSOF            (0x00000080)

/* Bit definitions and macros for MCF_USB_USBIMR */
#define MCF_USB_USBIMR_ISOERR          (0x00000001)
#define MCF_USB_USBIMR_FTUNLCK         (0x00000002)
#define MCF_USB_USBIMR_SUSP            (0x00000004)
#define MCF_USB_USBIMR_RES             (0x00000008)
#define MCF_USB_USBIMR_UPDSOF          (0x00000010)
#define MCF_USB_USBIMR_RSTSTOP         (0x00000020)
#define MCF_USB_USBIMR_SOF             (0x00000040)
#define MCF_USB_USBIMR_MSOF            (0x00000080)

/* Bit definitions and macros for MCF_USB_EPSTAT */
#define MCF_USB_EPSTAT_RST             (0x00000001)
#define MCF_USB_EPSTAT_FLUSH           (0x00000002)
#define MCF_USB_EPSTAT_DIR             (0x00000080)
#define MCF_USB_EPSTAT_BYTECNT(x)      (((x)&0x00000FFF)<<16)

/* Bit definitions and macros for MCF_USB_EPISR */
#define MCF_USB_EPISR_EOF              (0x00000001)
#define MCF_USB_EPISR_EOT              (0x00000004)
#define MCF_USB_EPISR_FIFOLO           (0x00000010)
#define MCF_USB_EPISR_FIFOHI           (0x00000020)
#define MCF_USB_EPISR_ERR              (0x00000040)
#define MCF_USB_EPISR_EMT              (0x00000080)
#define MCF_USB_EPISR_FU               (0x00000100)

/* Bit definitions and macros for MCF_USB_EPIMR */
#define MCF_USB_EPIMR_EOF              (0x00000001)
#define MCF_USB_EPIMR_EOT              (0x00000004)
#define MCF_USB_EPIMR_FIFOLO           (0x00000010)
#define MCF_USB_EPIMR_FIFOHI           (0x00000020)
#define MCF_USB_EPIMR_ERR              (0x00000040)
#define MCF_USB_EPIMR_EMT              (0x00000080)
#define MCF_USB_EPIMR_FU               (0x00000100)

/* Bit definitions and macros for MCF_USB_EPFRCFGR */
#define MCF_USB_EPFRCFGR_DEPTH(x)      (((x)&0x00001FFF)<<0)
#define MCF_USB_EPFRCFGR_BASE(x)       (((x)&0x00000FFF)<<16)

/* Bit definitions and macros for MCF_USB_EPFDR */
#define MCF_USB_EPFDR_ADDR0            ((void*)(&__MBAR[0x0000B450]))
#define MCF_USB_EPFDR_ADDR1            ((void*)(&__MBAR[0x0000B480]))
#define MCF_USB_EPFDR_ADDR2            ((void*)(&__MBAR[0x0000B4B0]))
#define MCF_USB_EPFDR_ADDR3            ((void*)(&__MBAR[0x0000B4E0]))
#define MCF_USB_EPFDR_ADDR4            ((void*)(&__MBAR[0x0000B510]))
#define MCF_USB_EPFDR_ADDR5            ((void*)(&__MBAR[0x0000B540]))
#define MCF_USB_EPFDR_ADDR6            ((void*)(&__MBAR[0x0000B570]))
#define MCF_USB_EPFDR_ADDR(x)          ((void*)(&__MBAR[0x00B450+((x)*0x030)]))

/* Bit definitions and macros for MCF_USB_EPFSR */
#define MCF_USB_EPFSR_EMT              (0x00010000)
#define MCF_USB_EPFSR_ALRM             (0x00020000)
#define MCF_USB_EPFSR_FR               (0x00040000)
#define MCF_USB_EPFSR_FU               (0x00080000)
#define MCF_USB_EPFSR_OF               (0x00100000)
#define MCF_USB_EPFSR_UF               (0x00200000)
#define MCF_USB_EPFSR_RXW              (0x00400000)
#define MCF_USB_EPFSR_FAE              (0x00800000)
#define MCF_USB_EPFSR_FRM(x)           (((x)&0x0000000F)<<24)
#define MCF_USB_EPFSR_TXW              (0x40000000)
#define MCF_USB_EPFSR_IP               (0x80000000)

/* Bit definitions and macros for MCF_USB_EPFCR */
#define MCF_USB_EPFCR_COUNTER(x)       (((x)&0x0000FFFF)<<0)
#define MCF_USB_EPFCR_TXWMSK           (0x00040000)
#define MCF_USB_EPFCR_OFMSK            (0x00080000)
#define MCF_USB_EPFCR_UFMSK            (0x00100000)
#define MCF_USB_EPFCR_RXWMSK           (0x00200000)
#define MCF_USB_EPFCR_FAEMSK           (0x00400000)
#define MCF_USB_EPFCR_IPMSK            (0x00800000)
#define MCF_USB_EPFCR_GR(x)            (((x)&0x00000007)<<24)
#define MCF_USB_EPFCR_FRM              (0x08000000)
#define MCF_USB_EPFCR_TMR              (0x10000000)
#define MCF_USB_EPFCR_WFR              (0x20000000)
#define MCF_USB_EPFCR_SHAD             (0x80000000)

/* Bit definitions and macros for MCF_USB_EPFAR */
#define MCF_USB_EPFAR_ALRMP(x)         (((x)&0x00000FFF)<<0)

/* Bit definitions and macros for MCF_USB_EPFRP */
#define MCF_USB_EPFRP_RP(x)            (((x)&0x00000FFF)<<0)

/* Bit definitions and macros for MCF_USB_EPFWP */
#define MCF_USB_EPFWP_WP(x)            (((x)&0x00000FFF)<<0)

/* Bit definitions and macros for MCF_USB_EPLRFP */
#define MCF_USB_EPLRFP_LRFP(x)         (((x)&0x00000FFF)<<0)

/* Bit definitions and macros for MCF_USB_EPLWFP */
#define MCF_USB_EPLWFP_LWFP(x)         (((x)&0x00000FFF)<<0)

/********************************************************************/

#endif /* __MCF548X_USB_H__ */
